# 画面設計書 9-Rule Files

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）のRule Files画面（Page ID: 8）の設計書である。Rule Files画面は、品質チェックルールのJSONファイルによるインポート・エクスポートを行うモーダルダイアログ画面である。

### 本画面の処理概要

Rule Files画面は、QUASTOのルール定義をJSONファイル形式でインポート・エクスポートする機能を提供する。これにより、異なる環境間でルール定義を共有したり、ルール定義をバックアップしたりすることが可能になる。

**業務上の目的・背景**：複数の開発環境やテスト環境が存在する場合、ルール定義を環境間で共有する必要がある。また、ルール定義のバージョン管理や変更履歴の追跡も重要である。本画面は、JSON形式でのルール定義のインポート・エクスポートを提供することで、環境間のルール移行やバックアップを容易にする。クライアント/プロジェクト単位でのエクスポートにより、選択的なルール移行が可能。

**画面へのアクセス方法**：Rules画面から「Rule Files」ボタンをクリックしてモーダルダイアログとして開く。

**主要な操作・処理内容**：
1. Import Rules: JSONファイルをアップロードしてルール定義をインポート
2. Export Rules: クライアント/プロジェクト単位でルール定義をJSONファイルとしてダウンロード
3. Closeボタンでダイアログを閉じて親画面に戻る

**画面遷移**：
- 遷移元：Rules画面（Rule Filesボタン）
- 遷移先：なし（モーダルダイアログのためCloseで親画面に戻る）

**権限による表示制御**：Protection Level「C」（認証必須）が設定されており、ログイン済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | ルールインポート・エクスポート | 主機能 | JSONファイルからルール定義をインポート・エクスポート |

## 画面種別

モーダルダイアログ（ファイル操作系）

## URL/ルーティング

- Page ID: 8
- エイリアス: RULE-FILES
- URL例: `f?p=141:8:SESSION_ID`（ダイアログとして開くことを推奨）

## 入出力項目

### Import Rules（折りたたみリージョン）

| 項目名 | 項目ID | タイプ | 必須 | 説明 |
|--------|--------|--------|------|------|
| JSON file | P8_JSON_FILE | ファイルアップロード | Yes | インポートするJSONファイル |

**ファイルアップロード設定**:
- 保存先: APEX_APPLICATION_TEMP_FILES
- ストレージタイプ: SESSION
- 許可するファイル形式: .json
- 表示スタイル: DROPZONE_BLOCK（ドラッグ&ドロップ対応）

### Export Rules（折りたたみリージョン）

| 項目名 | 表示形式 | データソース | 説明 |
|--------|----------|-------------|------|
| Download | リンク（ダウンロードアイコン） | Application Process | JSONファイルダウンロードリンク |
| Client Name | テキスト | QA_CLIENT_NAMES_P0008_V.QARU_CLIENT_NAME | クライアント/プロジェクト名 |

**レポート設定**:
- データソース: QA_CLIENT_NAMES_P0008_Vビュー
- データなしメッセージ: No rules defined.
- ソート: QARU_CLIENT_NAME降順

### ボタン

| ボタン名 | 項目ID | 配置位置 | アクション |
|---------|--------|----------|----------|
| Close | CLOSE | CLOSE | ダイアログを閉じる |
| Import | IMPORT | NEXT | JSONファイルをインポート |

## イベント仕様

### 1-Close Dialog

**トリガー**: CLOSEボタンクリック

**処理フロー**:
1. ダイアログを閉じる（NATIVE_DIALOG_CLOSE）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページロード | QA_CLIENT_NAMES_P0008_V | SELECT | エクスポート可能なクライアント一覧を取得 |
| Import | QA_IMPORT_FILES | INSERT | インポートファイル情報を保存 |
| Import | QA_RULES | INSERT/UPDATE | JSONファイルからルール定義をインポート |
| Export | QA_RULES | SELECT | 選択したクライアントのルールをJSONファイルとしてダウンロード |

### プロセス別詳細

#### Import file（IMPORTボタン押下時）

**PL/SQLコード**:
```sql
qa_apex_app_pkg.p_upload_rules_json(pi_file_name => :P8_JSON_FILE);
```

**処理フロー**:
1. APEX_APPLICATION_TEMP_FILESからアップロードファイルを取得
2. MIMEタイプが「application/json」であることを確認
3. qa_export_import_rules_pkg.f_import_clob_to_qa_import_filesでインポートファイル情報を保存
4. qa_export_import_rules_pkg.p_import_clob_to_rules_tableでルールをQA_RULESテーブルにインポート

#### Export（Downloadリンククリック時）

**Application Process**: getRuleJSONAttachment

**処理フロー**:
1. AI_CLIENT_NAMEパラメータからクライアント名を取得
2. qa_apex_app_pkg.p_download_rules_jsonを呼び出し
3. HTTPヘッダーを設定してJSONファイルをダウンロード

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 成功 | インポート成功時 | File imported. |
| - | 情報 | エクスポート可能なクライアントなし | No rules defined. |
| - | エラー | 無効なMIMEタイプ | Invalid MIME type of json file: {ファイル名} - MIME type: {MIMEタイプ} |

## 例外処理

| 例外状態 | 表示・動作 |
|---------|----------|
| 無効なMIMEタイプ | 「Invalid MIME type of json file」エラーを表示 |
| ファイルアップロードエラー | qa_logger_pkgでエラーログを記録し、例外を再スロー |
| JSONパースエラー | qa_logger_pkgでエラーログを記録し、例外を再スロー |
| エクスポートエラー | qa_logger_pkgでエラーログを記録し、例外を再スロー |

## 備考

- 本画面はモーダルダイアログとして表示され、親画面（Rules）の上に重ねて表示される
- Import/Exportリージョンは折りたたみ式（Collapsible）で、デフォルトは折りたたみ状態
- JSONファイルはクライアント/プロジェクト単位でエクスポートされる
- インポート時に既存ルールとの重複は、インポートファイル側のデータで上書きされる可能性がある
- ダウンロードファイル名は「export_rules_{クライアント名}_{日時}.json」形式
- AutocompleteはセキュリティのためOFFに設定
- ファイルアップロードはセッション単位で管理

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | モーダルダイアログとファイルアップロード/レポートの構成 |

**主要処理フロー**:
1. **行14-24**: `wwv_flow_imp_page.create_page`でモーダルダイアログ設定
2. **行25-45**: Export Rulesリージョン（折りたたみ）の定義
3. **行37-79**: Rulesインタラクティブ・レポート（クライアント一覧）の定義
4. **行136-159**: Buttons Containerリージョンの定義
5. **行148-159**: Import Rulesリージョン（折りたたみ）の定義
6. **行160-186**: ボタン定義（CLOSE、IMPORT）
7. **行187-203**: P8_JSON_FILEファイルアップロード項目の定義
8. **行204-222**: Dynamic Action（Close Dialog）の定義
9. **行223-235**: Import fileプロセスの定義

#### Step 2: PL/SQLパッケージを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_rules_json、p_download_rules_jsonの実装 |

**主要処理フロー**:
- **qa_apex_app_pkg.sql 行117-161**: `p_upload_rules_json`でJSONファイルをインポート
- **qa_apex_app_pkg.sql 行163-207**: `p_download_rules_json`でJSONファイルをダウンロード

### プログラム呼び出し階層図

```
Rule Files Page (Page 8)
    |
    +-- [Button: IMPORT - Submit]
    |       |
    |       +-- Process: Import file
    |               |
    |               +-- qa_apex_app_pkg.p_upload_rules_json
    |                       |
    |                       +-- APEX_APPLICATION_TEMP_FILES (SELECT)
    |                       |
    |                       +-- MIME Type Validation
    |                       |
    |                       +-- qa_export_import_rules_pkg.f_import_clob_to_qa_import_files
    |                               |
    |                               +-- INSERT INTO QA_IMPORT_FILES
    |                       |
    |                       +-- qa_export_import_rules_pkg.p_import_clob_to_rules_table
    |                               |
    |                               +-- INSERT/UPDATE QA_RULES
    |
    +-- [Link: Download - Application Process]
    |       |
    |       +-- getRuleJSONAttachment
    |               |
    |               +-- qa_apex_app_pkg.p_download_rules_json
    |                       |
    |                       +-- qa_export_import_rules_pkg.f_export_rules_table_to_clob
    |                               |
    |                               +-- SELECT FROM QA_RULES
    |                       |
    |                       +-- HTTP Header設定
    |                       |
    |                       +-- HTP.prn (JSONコンテンツ出力)
    |
    +-- [Button: CLOSE]
            |
            +-- Dynamic Action: Close Dialog
```

### データフロー図

```
[インポート]

JSONファイル             qa_apex_app_pkg              QA_RULES
(APEX_APPLICATION_  ───> .p_upload_rules_json    ───> (INSERT/UPDATE)
TEMP_FILES)                    |
                               v
                        qa_export_import_rules_pkg
                        .f_import_clob_to_qa_import_files
                        .p_import_clob_to_rules_table

[エクスポート]

QA_RULES                 qa_apex_app_pkg              JSONファイル
(SELECT)            <──── .p_download_rules_json <──── ダウンロード
                               |
                               v
                        qa_export_import_rules_pkg
                        .f_export_rules_table_to_clob
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | ソース | Rule Files画面定義 |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | JSONインポート・エクスポート処理 |
| qa_export_import_rules_pkg.sql | `src/plsql/pkg/qa_export_import_rules_pkg.sql` | ソース | ルールデータ変換処理（想定） |
| page_00006.sql | `src/apex/f141/application/pages/page_00006.sql` | ソース | Rules画面（呼び出し元） |
